% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomix.R
\name{plot.Binomix}
\alias{plot.Binomix}
\alias{summary.Binomix}
\title{Plot and summary of \code{Binomix} objects}
\usage{
\method{plot}{Binomix}(x, type = "pan", cex = 2, ncomp = NA,
  show.bar = TRUE, ...)

\method{summary}{Binomix}(object, ...)
}
\arguments{
\item{x}{A \code{Binomix} object, see below.}

\item{type}{Type of plot, default is \samp{type="pan"} which means the pie chart shows distribution
over the entire pan-genome. The alternative is \samp{type="single"} which means the pie chart will
show the distribution within a single (average) genome.}

\item{cex}{Plot symbol scaling.}

\item{ncomp}{Which model to display. You can override the display of the optimal (minimum BIC) model
by specifying the number of components here, e.g. \samp{ncomp=5} will always display the model with
\samp{5} components regardless of its BIC value.}

\item{show.bar}{Logical indicating if a colorbar should be displayed next to the pie.}

\item{object}{A \code{Binomix} object, see below.}

\item{\dots}{Optional graphical arguments.}
}
\description{
Generic functions for \code{Binomix} objects.
}
\details{
A \code{Binomix} object contains a series of fitted binomial mixture models. It is a small
(S3) extension to a \code{list}, having two components. These are named \samp{BIC.table} and
\samp{Mix.list}, see \code{\link{binomixEstimate}} for more details.

The \code{\link{plot.Binomix}} function will display a \code{Binomix} object as a pie chart. Only
the model with the smallest BIC-criterion value is displayed. The BIC-criterion is used to rank the
various fitted models, and minimum BIC is an objective criterion for finding the best model complexity.
Each sector of the pie chart is a component, the color of the sector indicates its detection probability
and the size of the sector its mixing proportion. This pie chart illustrates how gene clusters are
distributed within the pan-genome. Sectors of (dark) blue color are highly conserved gene clusters
(core genes), sectors of greenish colors are medium conserved clusters (shell genes) and sectors of
orange/pink colors are non-conserved clusters (cloud genes).

The \code{\link{summary.Binomix}} function will print the estimated core size and pan-genome size for
the optimal component model.
}
\examples{
# See examples in the Help-file for binomixEstimate.

}
\author{
Lars Snipen and Kristian Hovde Liland.
}
\seealso{
\code{\link{binomixEstimate}}.
}

