% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assumptions.R
\name{plot.assumptions_manova}
\alias{plot.assumptions_manova}
\title{Plot \emph{p}-values for testing the multivariate normality assumptions of
the MANOVA test}
\usage{
\method{plot}{assumptions_manova}(x, ...)
}
\arguments{
\item{x}{Objects of class \code{\link{assumptions_manova}}.}

\item{...}{Extra options passed to \code{\link[graphics]{barplot}}. The
\code{col} parameter defines colors for \emph{p}-values below 1, 0.05 and
0.01, respectively.}
}
\value{
None.
}
\description{
Plot method for objects of class \code{\link{assumptions_manova}} which
presents a bar plot containing the \emph{p}-values produced by the Royston
multivariate normality test (\code{\link[MVN]{mvn}}) for each group
being compared.
}
\examples{

# Plot the Royston test p-value for multivariate normality of each group
# (species) of the iris data
plot(assumptions_manova(iris[, 1:4], iris[, 5]))

# Plot the same data with logarithmic scale for p-values
plot(assumptions_manova(iris[, 1:4], iris[, 5]), log = "y")

}
