% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex_tables.R
\name{pvalf.default}
\alias{pvalf.default}
\title{Default p-value formatting method}
\usage{
\method{pvalf}{default}(pval, params = list())
}
\arguments{
\item{pval}{Numeric value between 0 and 1.}

\item{params}{A list of options. This function accepts the following options:
\describe{
  \item{minval}{If \emph{p}-value is below this value, return this value
        preceded by a "<" sign instead instead.}
  \item{lim1val}{If \emph{p}-value is below this value, it will be
        double-underlined.}
  \item{lim2val}{If \emph{p}-value is below this value, it will be
        underlined.}
  \item{na_str}{String to use for NAs. By default NAs are returned as is.}
}}
}
\value{
A string representing the formatted \code{pval}.
}
\description{
Format a \emph{p}-value for printing in a \code{LaTeX} table. Requires the
\emph{ulem} \code{LaTeX} package for underlining the \emph{p}-values.
}
\examples{
pvalf(0.1)
pvalf(0.000001)
pvalf(c(0.06, 0.04, 0.005, 0.00001), list(minval = 0.0001))

}

