% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micomp.R
\name{plot.assumptions_micomp}
\alias{plot.assumptions_micomp}
\title{Plot \emph{p}-values for testing the assumptions of the parametric tests used
in multiple output comparison}
\usage{
\method{plot}{assumptions_micomp}(x, ...)
}
\arguments{
\item{x}{Object of class \code{assumptions_micomp}.}

\item{...}{Extra options passed to \code{\link[graphics]{barplot}}.}
}
\value{
None.
}
\description{
Plot method for objects of class \code{assumptions_cmpoutput}
containing \emph{p}-values produced by testing the assumptions of the
parametric tests used for multiple output comparisons.
}
\details{
Several bar plots are presented, one for each comparison and output
combination, showing the several statistical tests employed to verify
the assumptions of the parametric tests.
}
\examples{
\donttest{
# Create a micomp object, use provided dataset
mic <- micomp(6, 0.65,
              list(list(name = "NLOKvsJEXOK", grpout = pphpc_ok),
                   list(name = "NLOKvsJEXNOSHUFF", grpout = pphpc_noshuff),
                   list(name = "NLOKvsJEXDIFF", grpout = pphpc_diff)))

# Plot the p-values of the statistic tests evaluating the assumptions of the
# comparisons performed in the mic object
plot(assumptions(mic))
}
}

