% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_articles_review_year.R
\name{subset_year}
\alias{subset_year}
\title{Subset data frame for abstracts published in a specific period}
\usage{
subset_year(df, col.year = Year, start = NULL, end = NULL)
}
\arguments{
\item{df}{Data frame containing publication years.}

\item{col.year}{Symbol. Column containing publication years.}

\item{start}{Integer. Optional. Beginning of
publication period.
If \code{start = NULL}, \code{start} is set to the least recent year in \code{df}.}

\item{end}{Integer. Optional. End of
publication period.
If \code{end = NULL}, \code{end} is set to the most recent year in \code{df}.}
}
\value{
Data frame containing abstracts published in a specific period
only.
}
\description{
Subset data frame for abstracts published in a specific period only.
}
\details{
Subset data frame for abstracts published in a specific period only.
All other abstracts published not within this period are silently
dropped.
}
\seealso{
\code{\link[=subset_research]{subset_research()}}, \code{\link[=subset_review]{subset_review()}}

Other subset functions: 
\code{\link{subset_df}()},
\code{\link{subset_mir_threshold}()},
\code{\link{subset_mir}()},
\code{\link{subset_research}()},
\code{\link{subset_review}()},
\code{\link{subset_snp}()}
}
\concept{subset functions}
