% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_mir_single_topic.R
\name{plot_mir_count}
\alias{plot_mir_count}
\title{Plot count of most frequently mentioned miRNA names}
\usage{
plot_mir_count(
  df,
  top = 10,
  colour = "steelblue3",
  col.mir = miRNA,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names.}

\item{top}{Integer. Specifies number of most frequent miRNA names to plot.}

\item{colour}{String. Colour of bar plot.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{title}{String. Plot title.}
}
\value{
Bar plot with the most frequently mentioned miRNAs names in \code{df}.
}
\description{
Plot count of most frequently mentioned miRNA names in a data frame.
}
\details{
Plot count of most frequently mentioned miRNA names in a data frame. How many
most frequently mentioned miRNAs are plotted is determined via the \code{top}
argument. Ties among the most frequently mentioned miRNAs are treated as
the same rank, e.g. if \emph{miR-126}, \emph{miR-34}, and \emph{miR-29} were all mentioned
the most often, they would all be plotted by specifying \code{top = 1}, \code{top = 2},
or \code{top = 3}.
}
\seealso{
\code{\link[=count_mir]{count_mir()}}, \code{\link[=count_mir_threshold]{count_mir_threshold()}}, \code{\link[=plot_mir_count_threshold]{plot_mir_count_threshold()}}

Other count functions: 
\code{\link{count_mir_threshold}()},
\code{\link{count_mir}()},
\code{\link{count_snp}()},
\code{\link{plot_mir_count_threshold}()}
}
\concept{count functions}
