% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePhenotypeSearch_function.R
\name{makePhenotypeSearch}
\alias{makePhenotypeSearch}
\title{Returns gene names with a given phenotype}
\usage{
makePhenotypeSearch(mgl, term = c(""), phen, saveFile = FALSE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{term}{Character vector representing phenotype of interest}

\item{phen}{List produced by \code{\link{makePhenotypes}}}

\item{saveFile}{A logical flag indicating whether a csv file ('PhenotypeSearch_[term].csv') should be saved in the current directory}
}
\description{
\code{makePhenotypeSearch} returns a character vector of gene names.
}
\details{
Of interest maybe groups of genes that have the same phenotype
}
\examples{
exMgl() -> myMgl
makePhenotypes(myMgl, saveFile = FALSE) -> myPhenotypes
makePhenotypeSearch(myMgl, term = 'Mean corpuscular hemoglobin', 
    phen = myPhenotypes, saveFile = FALSE) -> myPhenotypeSearch

}
\seealso{
\code{\link{makePhenotypes}}

Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}}, \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

