% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildFromNames_function.R
\name{buildFromNames}
\alias{buildFromNames}
\title{Build empty list using gene names.}
\usage{
buildFromNames(nm)
}
\arguments{
\item{nm}{A character vector with gene names}
}
\description{
\code{buildFromNames} returns an empty 'mgl' list given gene names.
}
\details{
This is one of three functions that can be used to set up the list structure.  It starts with gene names.
}
\section{Warning}{

If a gene is not found, a warning message will appear: 'Gene names missing: ...'.  This must be corrected or no other elements can be filled in as the remaining elements all build off of the disambigous ENSG identifier.  There are two strategies to fix this.  The first is to check gene names for typos or use of less common colloquial names.  The second is to use the missNames and fixNames functions in this pacakge to fill in the missing ENSG identifiers.  Note: googling the colloquial gene name and 'gene cards' is an excellent way to find an ENSG id.  Genecards does an exceptional job of cataloging alternative colloquial names.
}
\examples{
\dontrun{buildFromNames(nm = c('CETP', 'ABCA1', 'APOB')) -> myMgl}

}
\seealso{
Other Build list: \code{\link{buildFromEnsgs}},
  \code{\link{buildFromRegion}}
}

