% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_source.R
\name{report_last_modified}
\alias{report_last_modified}
\title{Report last modification date}
\usage{
report_last_modified(tbl)
}
\arguments{
\item{tbl}{Report data as a \link[tibble:tibble-package]{tibble}.}
}
\value{
A last modified date-time as a \link[base:DateTimeClasses]{POSIXct}
object.
}
\description{
\code{\link[=report_last_modified]{report_last_modified()}} returns the last modified date and time of the
report source: local file or remote file. If a local file, the modification
date will be that indicated by the file system; if a remote file, the date
of last update is that provided by HTTP header \code{"last-modified"}.

MGI updates its reports weekly, every Thursday. However, not all reports are
updated each week. The return value of this function is the closest you will
get to a versioning of MGI report files.
}
\examples{
markers <- read_report("marker_list1", n_max = 10L)

# When was the report file last updated?
report_last_modified(markers)

}
