% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{print.mfbvar_prior}
\alias{print.mfbvar_prior}
\title{Print method for mfbvar_prior}
\usage{
\method{print}{mfbvar_prior}(x, ...)
}
\arguments{
\item{x}{prior object (class \code{mfbvar_prior})}

\item{...}{additional arguments (currently unused)}
}
\description{
Printing method for object of class mfbvar_prior, checking if information
in the prior is sufficient for estimating models.
}
\details{
The print method checks whether the steady-state and Minnesota
  priors can be used with the current specification. This check is minimal in
  the sense that it checks only prior elements with no defaults, and it only
  checks for estimation and not forecasting (for which the steady-state prior
  requires additional information).
}
\examples{
prior_obj <- set_prior(Y = mf_usa, n_lags = 4, n_reps = 100)
print(prior_obj)
}
\seealso{
\code{\link{set_prior}}, \code{\link{update_prior}}, \code{\link{estimate_mfbvar}}, \code{\link{summary.mfbvar_prior}}
}
