% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{loglike}
\alias{loglike}
\alias{smoother}
\alias{simulation_smoother}
\alias{generate_mhh}
\title{Smooth and sample from the smoothed distribution}
\usage{
loglike(Y, Lambda, Pi_comp, Q_comp, n_T, n_vars, n_comp, z0, P0)
}
\arguments{
\item{Y}{The data matrix of size \code{(n_T + n_lags) * n_vars} with \code{NA} representing missingness. All monthly variables must be placed before quarterly variables.}

\item{Lambda}{The Lambda matrix (size \code{n_vars* (n_vars*n_lags)}).}

\item{Pi_comp}{Matrix with the dynamic coefficients in companion form.}

\item{Q_comp}{The lower-triangular Cholesky decomposition of the covariance matrix (in companion form).}

\item{n_T}{The number of time points.}

\item{n_vars}{The number of variables.}

\item{n_comp}{The length of the companion form vector of data (\code{n_vars*n_lags}).}

\item{z0}{A matrix of size \code{(n_lags*n_vars) * n_vars} of initial values of the latent variable.}

\item{P0}{The covariance matrix of the initial state (\code{(n_vars*n_lags)*(n_vars*n_lags)}).}
}
\value{
For \code{loglike}:
\item{}{An \code{n_T}-long vector of the log-likelihoods. \code{exp(sum(loglike(...)))} is the likelihood.}
}
\description{
Functions for smoothing and sampling from the (smoothed) distribution \eqn{p(Z_{1:T}|Y_{1:T}, \Theta)}.
}
\details{
Implemented in C++.
}
\section{Functions}{
\itemize{
\item \code{loglike}: Compute smoothed states
}}

\keyword{internal}
