% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{plot.mfbvar_minn}
\alias{plot.mfbvar_minn}
\title{Plotting method for class \code{mfbvar_minn}}
\usage{
\method{plot}{mfbvar_minn}(x, plot_start = NULL, pred_level = c(0.1,
  0.9), nrow_facet = NULL, ...)
}
\arguments{
\item{x}{object of class \code{mfbvar_minn}}

\item{plot_start}{Time period (number) to start plotting from. Default is to to use \code{5*n_fcst} time periods if \code{n_fcst} exists, otherwise the entire sample.}

\item{pred_level}{A vector with the lower and upper quantiles for the forecast intervals.}

\item{nrow_facet}{an integer giving the number of rows to use in the facet}

\item{...}{Currently not in use.}
}
\description{
Method for plotting mfbvar objects.
}
\examples{
prior_obj <- set_prior(Y = mf_sweden[, 4:5], freq = c("m", "q"),
                       n_lags = 4, n_burnin = 20, n_reps = 20, n_fcst = 4)
mod_minn <- estimate_mfbvar(prior_obj, prior_type = "minn")
plot(mod_minn)
}
