% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/metricsgraphics.R
\name{mjs_add_line}
\alias{mjs_add_line}
\title{Add a new line to a metricsgraphics.js linechart "geom"}
\usage{
mjs_add_line(mjs, y_accessor)
}
\arguments{
\item{mjs}{plot object}

\item{y_accessor}{bare or quoted name of column to add to the existing line plot}
}
\value{
metricsgraphics object
}
\description{
This function adds a line to an existing \code{mjs_line} "geom". Specify
the bare or quoted name of the column to use in \code{y_accessor} and it will be added
to the plot.
}
\note{
You must have called \code{mjs_line} first before adding additional columns
}
\examples{
set.seed(1492)
stocks <- data.frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4))

stocks \%>\%
  mjs_plot(x=time, y=X) \%>\%
  mjs_line() \%>\%
  mjs_add_line(Y) \%>\%
  mjs_add_line(Z) \%>\%
  mjs_axis_x(xax_format="date")
}

