% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesOverall.R
\name{sesOverall}
\alias{sesOverall}
\title{Overall per simulation-null-metric SES test}
\usage{
sesOverall(simulation.list, test, concat.by)
}
\arguments{
\item{simulation.list}{A summarized results list such as one output from
reduceResults(). See examples.}

\item{test}{Either "ttest" or "wilcotest", depending on whether the user wants to run
a two-sided t-test or a Wilcoxon signed rank test.}

\item{concat.by}{Whether randomizations were concatenated by richness, plot or both.}
}
\value{
A data frame summarizing the mean, overall standardized effect sizes and the
significance of those devations from expectations for each simulation, null, metric
combination. This test works across all iterations, and looks for overall shifts in
SES from expectations (see details for for expectations).
}
\description{
This function provides one of many ways of summarizing and considering simulation
results.
}
\details{
This function provides one way of summarizing and considering simulation
results. It takes as input a vector of all standardized effect sizes for all plots
from a given simulation-null-metric combination, and calculates the mean of the vector
and whether it differs significantly from a mean of zero. It does this either with a
simple two-sided t-test, or with a Wilcoxon signed rank test. If the latter, and if
there are three different spatial simulations with names random, filtering and
competition, the test is two-sided, less and greater, respectively.
}
\examples{
#not run
#results <- readIn()
#summ <- reduceResults(results)
#examp <- sesOverall(summ$ses, "both")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

