% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{deft_prepare}
\alias{deft_prepare}
\title{Prepare log transformation data for effect size estimation
according to confidence level and distribution}
\usage{
deft_prepare(data, distribution = c("N", "t"), conf_level = 0.05,
  df = Inf, var = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} contains at least columns 'trial', 'hr', 'ci.lb', 'ci.ub'.}

\item{distribution}{a character specify distribution.
'N' for normal, 't' for student distribution.
Default is N for normal distribution.}

\item{conf_level}{a number specify confidence level, default is 0.05.}

\item{df}{a number specify degree of freedom for t distribution}

\item{var}{default is FALSE. If TRUE, the sampling variance will be computed.}
}
\value{
a \code{data.frame}
}
\description{
A variety of different outcome measures which
used in meta-analysis as input are in the form of log, such as hazard ratio (HR).
This function is used to do log transformation to calculate effect size and
standard error. Then the result can be easier used for model fit.
}
\examples{
### specify hazard ratios (hr)
hr    <- c(0.30, 0.11, 1.25, 0.63, 0.90, 0.28)
### specify lower bound for hr confidence intervals
ci.lb <- c(0.09, 0.02, 0.82, 0.42, 0.41, 0.12)
### specify upper bound for hr confidence intervals
ci.ub <- c(1.00, 0.56, 1.90, 0.95, 1.99, 0.67)
### trials
trial <- c("Rizvi 2015", "Rizvi 2015",
          "Rizvi 2018", "Rizvi 2018",
          "Hellmann 2018", "Hellmann 2018")
### subgroups
subgroup = rep(c("Male", "Female"), 3)

entry <- paste(trial, subgroup, sep = "-")
### combine as data.frame

wang2019 =
   data.frame(
        entry = entry,
        trial = trial,
        subgroup = subgroup,
        hr = hr,
        ci.lb = ci.lb,
        ci.ub = ci.ub,
        stringsAsFactors = FALSE
       )

deft_prepare(wang2019)
}
\references{
Wang, Shixiang, et al. "The predictive power of tumor mutational burden
in lung cancer immunotherapy response is influenced by patients' sex."
International journal of cancer (2019).
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
