% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corsplom.R
\name{corsplom_gg_diagonal}
\alias{corsplom_gg_diagonal}
\title{Diagonal GG Function for Metaplot Corsplom}
\usage{
corsplom_gg_diagonal(data, mapping, .data, density = TRUE,
  diag.label = metOption("metaplot_diag_label_corsplom_gg", diag_label),
  pin = metOption("metaplot_pin_loc_corsplom_gg", diag_pin),
  pin.col = metOption("metaplot_pin_col_corsplom_gg", "darkgrey"),
  pin.alpha = metOption("metaplot_pin_alpha_corsplom_gg", 1),
  dens.col = metOption("metaplot_dens_col_corsplom_gg", "grey"),
  dens.scale = metOption("metaplot_dens_scale_corsplom_gg", 0.2),
  dens.alpha = metOption("metaplot_dens_alpha_corsplom_gg", 0.5),
  varname.cex = metOption("metaplot_varname_cex_corsplom_gg", 1),
  as.table = metOption("metaplot_astable_corsplom_gg", TRUE),
  dens.up = metOption("metaplot_densup_corsplom_gg", TRUE), ...)
}
\arguments{
\item{data}{data}

\item{mapping}{mapping}

\item{.data}{copy of original dataset}

\item{density}{whether to plot density polygons; can be a length 4 vector for top, right, bottom, left}

\item{diag.label}{label for the diagonal; can be a function of x, varname, .data}

\item{pin}{location for a pin (reference line) in the density region; can be a function of x, varname, .data}

\item{pin.col}{color of pin, if any}

\item{pin.alpha}{alpha transparency of pin}

\item{dens.col}{color for density region}

\item{dens.scale}{inflation factor for height of density smooth}

\item{dens.alpha}{alpha transparency for density region}

\item{varname.cex}{text size multiplier}

\item{as.table}{diagonal arranged top-left to bottom-right}

\item{dens.up}{whether density plots should face the upper triangle (or lower, if FALSE)}

\item{...}{passed arguments}
}
\description{
Default diagonal panel function for corsplom_data_frame with \code{gg = TRUE}. Plots a density smooth against the corresponding axis from within the diagonal panel.  Plots a grey pin at each axis zero. Formats and displays the variable name.
}
\seealso{
\code{\link{corsplom}}

Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{categorical_panel}},
  \code{\link{corsplom_gg_correlation}},
  \code{\link{corsplom_gg_scatter}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_diagonal}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_label}},
  \code{\link{diag_pin}}, \code{\link{iso_prepanel}},
  \code{\link{metaplot_key}}, \code{\link{metaplot_ref}},
  \code{\link{panel.meta_densityplot}},
  \code{\link{panel_tile}},
  \code{\link{scatter_panel_ref}},
  \code{\link{scatter_panel}}

Other corsplom: \code{\link{corsplom.data.frame}},
  \code{\link{corsplom_data_frame}},
  \code{\link{corsplom_gg_correlation}},
  \code{\link{corsplom_gg_scatter}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{corsplom}},
  \code{\link{plot.metaplot_gtable}},
  \code{\link{print.metaplot_gtable}}
}
\keyword{internal}
