% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{densplot_data_frame}
\alias{densplot_data_frame}
\title{Density Function for Data Frame}
\usage{
densplot_data_frame(x, xvar, groups = NULL, facets = NULL,
  xlab = getOption("metaplot_lab", axislabel),
  ref = getOption("metaplot_ref", metaplot_ref),
  ref.col = getOption("metaplot_ref.col", "grey"),
  ref.lty = getOption("metaplot_ref.lty", "solid"),
  ref.alpha = getOption("metaplot_ref.alpha", 1),
  log = getOption("metaplot_log", FALSE), crit = getOption("metaplot_crit",
  1.3), aspect = getOption("metaplot_aspect", 1),
  scales = getOption("metaplot_dens.scales", NULL),
  panel = getOption("metaplot_dens.panel", dens_panel),
  auto.key = getOption("metaplot_auto.key", NULL),
  keycols = getOption("metaplot_keycols", NULL),
  main = getOption("metaplot_main", NULL), sub = getOption("metaplot_sub",
  NULL), ...)
}
\arguments{
\item{x}{data.frame}

\item{xvar}{variable to plot}

\item{groups}{optional grouping variable}

\item{facets}{optional conditioning variables}

\item{xlab}{x axis label; can be function(x = x, var = xvar, log = log, ...)}

\item{ref}{reference line; can be function(x = x, var = xvar, ...)}

\item{ref.col}{color for reference line(s)}

\item{ref.lty}{type for reference line(s)}

\item{ref.alpha}{transparency for reference line(s)}

\item{log}{whether to log-transform x axis (auto-selected if NA)}

\item{crit}{if log is NA, log-transform if mean/median ratio for non-missing x is greater than this value (and no negative values)}

\item{aspect}{passed to \code{\link[lattice]{densityplot}}}

\item{scales}{passed to \code{\link[lattice]{densityplot}}}

\item{panel}{passed to \code{\link[lattice]{densityplot}}}

\item{auto.key}{passed to \code{\link[lattice]{densityplot}}}

\item{keycols}{number of auto.key columns}

\item{main}{character, or a function of x, xvar, groups, facets, and log}

\item{sub}{character, or a function of x, xvar, groups, facets, and log}

\item{...}{passed to \code{\link[lattice]{densityplot}}}
}
\description{
Plot density for object of class 'data.frame' using \code{dens_panel} by default.
}
\examples{
densplot_data_frame(Theoph, 'conc', grid = TRUE)
densplot_data_frame(Theoph, 'conc', 'Subject')
densplot_data_frame(Theoph, 'conc', , 'Subject')
}
\seealso{
Other univariate plots: \code{\link{dens_panel}},
  \code{\link{densplot.data.frame}},
  \code{\link{densplot}}, \code{\link{metaplot.data.frame}}

Other densplot: \code{\link{densplot.data.frame}},
  \code{\link{densplot}}

Other metaplot: \code{\link{boxplot_data_frame}},
  \code{\link{corsplom_data_frame}},
  \code{\link{metaplot}}, \code{\link{scatter_data_frame}}
}
