% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{corsplom_panel_diagonal}
\alias{corsplom_panel_diagonal}
\title{Diagonal Panel Function for Metaplot Corsplom}
\usage{
corsplom_panel_diagonal(x, varname, .data, density = TRUE,
  diag.label = getOption("metaplot_diag.label", diag_label),
  pin = getOption("metaplot_pin", diag_pin),
  pin.col = getOption("metaplot_pin.col", "darkgrey"),
  pin.alpha = getOption("metaplot_pin.alpha", 1),
  dens.col = getOption("metaplot_dens.col", "grey"),
  dens.scale = getOption("metaplot_dens.scale", 0.2),
  dens.alpha = getOption("metaplot_dens.alpha", 0.5), ...)
}
\arguments{
\item{x}{numeric}

\item{varname}{variable name}

\item{.data}{copy of original dataset}

\item{density}{whether to plot density polygons}

\item{diag.label}{label for the diagonal; can be a function of x, varname, .data}

\item{pin}{location for a pin (reference line) in the density region; can be a function of x, varname, .data}

\item{pin.col}{color of pin, if any}

\item{pin.alpha}{alpha transparency of pin}

\item{dens.col}{color for density region}

\item{dens.scale}{inflation factor for height of density smooth}

\item{dens.alpha}{alpha transparency for density region}

\item{...}{passed arguments}
}
\description{
Default diagonal panel function for corsplom_data_frame. Plots a density smooth against the corresponding axis from within the diagonal panel.  Plots a grey pin at each axis zero.
}
\seealso{
\code{\link{corsplom}}

Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_label}},
  \code{\link{diag_pin}}, \code{\link{iso_prepanel}},
  \code{\link{metaplot_ref}},
  \code{\link{scatter_panel_ref}},
  \code{\link{scatter_panel}}
}
\keyword{internal}
