% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_featuretable}
\alias{read_featuretable}
\title{Read a feature table into a tidy tibble}
\usage{
read_featuretable(file, delim = ",", label_col = 1, metadata_cols = NULL, ...)
}
\arguments{
\item{file}{A path to a file but can also be a connection or literal data.}

\item{delim}{The field separator or delimiter. For example "," in csv files.}

\item{label_col}{The index or name of the column that will be used to label Features. For example an identifier (\emph{e.g.}, KEGG, CAS, HMDB) or a \emph{m/z}-RT pair.}

\item{metadata_cols}{The index/indices or name(s) of column(s) that hold additional feature metadata (\emph{e.g.}, retention times, additional identifiers or \emph{m/z} values).}

\item{...}{Additional arguments passed on to \code{readr::read_delim()}}
}
\value{
A tidy tibble.
}
\description{
Basically a wrapper around \code{readr::read_delim()} but performs some initial tidying operations such as \code{gather()} rearranging columns. The \code{label_col} will be renamed to \emph{Feature}.
}
\examples{
# Read a toy dataset in the format produced with Bruker MetaboScape (Version 2021).
featuretable_path <- system.file("extdata", "toy_metaboscape.csv", package = "metamorphr")

# Example 1: Provide indices for metadata_cols
featuretable <- read_featuretable(featuretable_path, metadata_cols = 2:5)

featuretable

# Example 2: Provide a name for label_col and indices for metadata_cols
featuretable <- read_featuretable(
  featuretable_path,
  label_col = "m/z",
  metadata_cols = c(1, 2, 4, 5)
)

featuretable

# Example 3: Provide names for both, label_col and metadata_cols
featuretable <- read_featuretable(
  featuretable_path,
  label_col = "m/z",
  metadata_cols = c("Bucket label", "RT", "Name", "Formula")
)

featuretable

}
\references{
\itemize{
\item H. Wickham, \emph{J. Stat. Soft.} \strong{2014}, \emph{59}, DOI 10.18637/jss.v059.i10.
\item H. Wickham, M. Averick, J. Bryan, W. Chang, L. McGowan, R. François, G. Grolemund, A. Hayes, L. Henry, J. Hester, M. Kuhn, T. Pedersen, E. Miller, S. Bache, K. Müller, J. Ooms, D. Robinson, D. Seidel, V. Spinu, K. Takahashi, D. Vaughan, C. Wilke, K. Woo, H. Yutani, \emph{JOSS} \strong{2019}, \emph{4}, 1686, DOI 10.21105/joss.01686.
\item “12 Tidy data | R for Data Science,” can be found under \url{https://r4ds.had.co.nz/tidy-data.html}, \strong{2023}.
}
}
