% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFA.Algorithm.R
\name{FFA}
\alias{FFA}
\title{Optimization using Firefly Algorithm}
\usage{
FFA(FUN, optimType = "MIN", numVar, numPopulation = 40, maxIter = 500,
  rangeVar, B0 = 1, gamma = 1, alpha = 0.2)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization. 
Otherwise, you can use \code{"MAX"} for maximization problem.}

\item{numVar}{a positive integer to determine the number variable.}

\item{numPopulation}{a positive integer to determine the number population.}

\item{maxIter}{a positive integer to determine the maximum number of iteration.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables, 
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively. 
If all variable have equal upper bound, you can define \code{rangeVar} as 
matrix (\eqn{2 \times 1}).}

\item{B0}{a positive integer to determine the attractiveness firefly at r=0.}

\item{gamma}{a positive integer to determine light absorption coefficient.}

\item{alpha}{a positive integer to determine randomization parameter.}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable 
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Firefly 
Algorithm. It is used to solve continuous optimization tasks. 
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by Xin-She Yang in 2009.
The firefly algorithm (FFA) mimics the behavior of fireflies, which use 
a kind of flashing light to communicate with other members of their species. 
Since the intensity of the light of a single firefly diminishes with 
increasing distance, the FFA is implicitly able to detect local solutions 
on its way to the best solution for a given objective function.

In order to find the optimal solution, the algorithm follow the following steps. 
\itemize{
\item Initialization: Initialize the first population of fireflies randomly, 
      calculate the fitness of fireflies and assumes fitness values as
      Light Intensity.
\item Update the firefly position based on the attractiveness. The firefly that have higher light  
      intensity will tend to attract other fireflies. The attracted firefly will move based on
      the parameter that given by user.
\item Calculate the fitness and update the best firefly position.
\item Check termination criteria, if termination criterion is satisfied, return the 
      best position as the optimal solution for given problem. Otherwise, back to Update firefly position steps.
}
}
\examples{
################################## 
## Optimizing the sphere function

# define sphere function as objective function
sphere <- function(X){
    return(sum(X^2))
}

## Define parameter 
B0 <- 1
gamma <- 1
alpha <- 0.2
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using Firefly Algorithm
resultFFA <- FFA(sphere, optimType="MIN", numVar, numPopulation=20, 
                 maxIter=100, rangeVar, B0, gamma, alpha)

## calculate the optimum value using sphere function
optimum.value <- sphere(resultFFA)

}
\references{
X.-S. Yang, Firefly algorithms for multimodal optimization, in: 
Stochastic Algorithms: Foundations and Applications, SAGA 2009, 
Lecture Notes in Computer Sciences, Vol. 5792, pp. 169-178 (2009).
}
\seealso{
\code{\link{metaOpt}}
}
