% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_inconsistent_labels}
\alias{check_inconsistent_labels}
\alias{check_inconsistent_types}
\alias{check_inconsistent_formats}
\title{Optional checks to consistency of metadata}
\usage{
check_inconsistent_labels(metacore)

check_inconsistent_types(metacore)

check_inconsistent_formats(metacore)
}
\arguments{
\item{metacore}{metacore object to check}
}
\value{
If all variables are consistent it will return a message. If there
are inconsistencies it will return a message and a dataset of the variables
with inconsistencies.
}
\description{
These functions check to see if values (e.g labels, formats)
that should be consistent for a variable across all data are actually
consistent.
}
\examples{
## EXAMPLE WITH DUPLICATES
# Loads in a metacore obj called metacore
load(metacore_example("pilot_ADaM.rda"))
check_inconsistent_labels(metacore)

check_inconsistent_types(metacore)

## EXAMPLE WITHOUT DUPLICATES
# Loads in a metacore obj called metacore
load(metacore_example("pilot_SDTM.rda"))
check_inconsistent_labels(metacore)

check_inconsistent_formats(metacore)

check_inconsistent_types(metacore)
}
