% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaconfoundr.R
\name{metaconfoundr()}
\alias{metaconfoundr()}
\alias{metaconfoundr}
\title{Prepare a meta-analysis data set for metaconfoundr}
\usage{
metaconfoundr(.df, data_format = mc_detect_layout())
}
\arguments{
\item{.df}{A data frame. See the vignette on data preparation for more
details.}

\item{data_format}{The format of the data. Detected automatically by default,
but explicit options include \code{\link[=mc_longer]{mc_longer()}} and \code{\link[=mc_wider]{mc_wider()}}}
}
\value{
a tibble
}
\description{
\code{metaconfoundr()} standardizes data frames with information on how well a set
of studies control for a set of variables. In this approach, a set of domain
experts agree on the variables that are required to properly control for
confounding for a scientific question. Then, for a given confounder, the
studies are described as being adequately controlled, inadequately
controlled, or controlled with some concerns. \code{metaconfoundr()} is intended
to standardize data for use in \code{\link[=mc_heatmap]{mc_heatmap()}} and \code{\link[=mc_trafficlight]{mc_trafficlight()}}.
See the vignette on data preparation for more information on how to set up
your evaluation.
}
\examples{

metaconfoundr(ipi)

metaconfoundr(ipi_wide)

ipi_wide2 <- ipi_wide \%>\%
  dplyr::rename(scope = construct)

metaconfoundr(ipi_wide2, mc_wider(construct = "scope"))


}
