% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{supertaxa}
\alias{supertaxa}
\title{Get all supertaxa of a taxon}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object containing taxon
information to be queried.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find supertaxa for.
Default: All taxa in `obj` will be used. Any variable name that appears in
[all_names()] can be used as if it was a vector on its own.}

\item{recursive}{(`logical` or `numeric`) If `FALSE`, only return the
supertaxa one rank above the target taxa. If `TRUE`, return all the
supertaxa of every supertaxa, etc. Positive numbers indicate the number of
recursions (i.e. number of ranks above the target taxon to return). `1` is
equivalent to `FALSE`. Negative numbers are equivalent to `TRUE`.}

\item{simplify}{(`logical`) If `TRUE`, then combine all the results into a
single vector of unique values.}

\item{include_input}{(`logical`) If `TRUE`, the input taxa are included in
the output}

\item{value}{What data to return. Any result of [all_names()] can be used, but it
usually only makes sense to use data that has an associated taxon id.}

\item{na}{(`logical`) If `TRUE`, return `NA` where information
is not available.}
}
\value{
If `simplify = FALSE`, then a list of vectors are returned
  corresponding to the `subset` argument. If `simplify = TRUE`,
  then unique values are returned in a single vector.
}
\description{
Return data for supertaxa (i.e. all taxa the target
taxa are a part of) of each taxon in a [taxonomy()] or [taxmap()] object.
\preformatted{
obj$supertaxa(subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE,
  value = "taxon_indexes", na = FALSE)
supertaxa(obj, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE,
  value = "taxon_indexes", na = FALSE)}
}
\examples{
# return the indexes for supertaxa for each taxon
supertaxa(ex_taxmap)

# Only return data for some taxa using taxon indexes
supertaxa(ex_taxmap, subset = 1:3)

# Only return data for some taxa using taxon ids
supertaxa(ex_taxmap, subset = c("d", "e"))

# Only return data for some taxa using logical tests
supertaxa(ex_taxmap, subset = taxon_ranks == "species")

# Only return supertaxa one level above
supertaxa(ex_taxmap, recursive = FALSE)

# Only return supertaxa some number of ranks above
supertaxa(ex_taxmap, recursive = 2)

# Return something besides taxon indexes
supertaxa(ex_taxmap, value = "taxon_names")
}
\seealso{
Other taxonomy indexing functions: 
\code{\link{branches}()},
\code{\link{internodes}()},
\code{\link{leaves}()},
\code{\link{roots}()},
\code{\link{stems}()},
\code{\link{subtaxa}()}
}
\concept{taxonomy indexing functions}
