% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{is_leaf}
\alias{is_leaf}
\title{Test if taxa are leaves}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object.}
}
\value{
A `logical` of length equal to the number of taxa.
}
\description{
Test if taxa are leaves in a [taxonomy()] or [taxmap()] object. Leaves are taxa
without subtaxa, typically species.
\preformatted{
obj$is_leaf()
is_leaf(obj)}
}
\examples{
# Test which taxon IDs correspond to leaves
is_leaf(ex_taxmap)

# Filter out leaves
filter_taxa(ex_taxmap, ! is_leaf)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data_}()},
\code{\link{map_data}()},
\code{\link{n_leaves_1}()},
\code{\link{n_leaves}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
