% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option_parsers.R
\name{get_taxmap_other_cols}
\alias{get_taxmap_other_cols}
\title{Parse the other_cols option}
\usage{
get_taxmap_other_cols(obj, data, cols, other_cols = NULL)
}
\arguments{
\item{obj}{A taxmap object}

\item{data}{The name of a table in \code{obj} that contains counts.}

\item{cols}{The names/indexes of columns in \code{data} to use. Takes one
of the following inputs:
\describe{
  \item{TRUE/FALSE:}{All columns will used.}
  \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Use the columns
corresponding to \code{TRUE} values.}
  \item{Character vector:}{The names of columns to use}
  \item{Numeric vector:}{The indexes of columns to use}
}}

\item{other_cols}{Preserve in the output non-target columns present in the
input data. The "taxon_id" column will always be preserved. Takes one of
the following inputs:
\describe{
  \item{TRUE/FALSE:}{All non-target columns will be preserved or not.}
  \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Preserve the columns
corresponding to \code{TRUE} values.}
  \item{Character vector:}{The names of columns to preserve}
  \item{Numeric vector:}{The indexes of columns to preserve}
}}
}
\description{
Parse the other_cols option used in many calculation functions.
}
\examples{
\dontrun{
# Parse data for examples
x = parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                   class_key = c(tax_rank = "taxon_rank", tax_name = "taxon_name"),
                   class_regex = "^(.+)__(.+)$")

# If all cols are used, there are no other cols, only "taxon_id"
metacoder:::get_taxmap_other_cols(x, data = "tax_data", cols = TRUE)

# If a subset of target columns is specified, the rest are returned 
metacoder:::get_taxmap_other_cols(x, data = "tax_data", cols = 2:3)

# Additionally, a subset of other columns can be specified
metacoder:::get_taxmap_other_cols(x, data = "tax_data", cols = 2:3,
                                  other_cols = 4:5)
                   
}
}
\seealso{
Other option parsers: \code{\link{get_taxmap_cols}},
  \code{\link{get_taxmap_data}},
  \code{\link{get_taxmap_table}},
  \code{\link{verify_taxmap}}
}
\concept{option parsers}
\keyword{internal}
