% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{load_data}
\alias{load_data}
\title{Load metabolite data from three separate files}
\usage{
load_data(
  data_path = NULL,
  feature_path = NULL,
  sample_path = NULL,
  featureID = "CHEM_ID",
  sampleID = "PARENT_SAMPLE_NAME"
)
}
\arguments{
\item{data_path}{Path to the metabolite measurements (peak area data or normalized data, 
sample [row] * feature [column])}

\item{feature_path}{Path to the metabolite annotation (chemical annotation)}

\item{sample_path}{Path to the sample annotation (sample meta data)}

\item{featureID}{a character of the metabolite ID column (in feature file and the column names of data file), 
default: CHEM_ID (provided from Metabolon file)}

\item{sampleID}{a character of the sample ID column (in sample file and the first column of data file), 
default: PARENT_SAMPLE_NAME (provided from Metabolon file).}
}
\value{
A Metabolite object with slots: assayData, featureData, and sampleData.
}
\description{
Load metabolite data from three separate files (import files using `fread` from data.table).
}
