% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submnet.R
\name{fitness}
\alias{fitness}
\title{Fitness of gene removal-based submodels with different gene rankings}
\usage{
fitness(
  model,
  ranks,
  rescue.weight = NULL,
  step = 1,
  draw.num = 0,
  obj.react = NA,
  mc.cores = 1,
  timeout = 12,
  tol = SYBIL_SETTINGS("TOLERANCE"),
  solver = SYBIL_SETTINGS("SOLVER"),
  method = SYBIL_SETTINGS("METHOD")
)
}
\arguments{
\item{model}{An object of class \code{modelorg} indicating the weighted \code{rescue} model obtained from the rescue process.}

\item{ranks}{A list of data frames of scores for ranking genes, with gene per row, e.g. data.frame(pkm=pkm expression, rel=relative expression).}

\item{rescue.weight}{A vector of rescue reaction weights. Default: NULL, the weights are computed from the given model with gene.num=1.}

\item{step}{An integer indicating the step in numbers of genes to remove. Default: 1, gene-by-gene removal. 
When there are many genes in the model, the step is multiplied by an exponent of 2 for later removals. 
This is to reduce the computing time for non-informative sub-models at the end of the series.}

\item{draw.num}{Number of random draws. Default: 0.}

\item{obj.react}{A string indicating objective reaction ID. Default: reaction producing BIOMASS.}

\item{mc.cores}{The number of cores to use (at least 1), i.e. at most how many child processes will be run simultaneously. Default: 1.}

\item{timeout}{The maximum time in seconds to allow for LP call to return. Default: 12.}

\item{tol}{The maximum value to be considered null. Default: \code{SYBIL_SETTINGS("TOLERANCE")}.}

\item{solver}{\code{\link{sybil}} solver. Default: \code{SYBIL_SETTINGS("SOLVER")}.}

\item{method}{\code{\link{sybil}} method. Default: \code{SYBIL_SETTINGS("METHOD")}.}
}
\value{
An object of class \code{scoreGeneDel} for the submodel construction simulation.
}
\description{
This function computes the fitness of submodels by removing genes in different gene rankings.
}
\examples{
data(Ec_core)
mod <- rescue(Ec_core, target=0.1)
mod.weight <- changeObjFunc(mod$rescue, react=rownames(mod$coef), obj_coef=mod$coef)
ranks <- list(
   rep.1=data.frame(
       expr=setNames(rnorm(length(sybil::allGenes(mod.weight)), mean=5, sd=4),
           sybil::allGenes(mod.weight))),
   rep.2=data.frame(
       expr=setNames(rnorm(length(sybil::allGenes(mod.weight)), mean=5, sd=4.1),
           sybil::allGenes(mod.weight))))
fn <- fitness(model=mod.weight, ranks=ranks, step=200, draw.num=1)
}
