% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_statistics.R
\name{es_from_ancova_t_pval}
\alias{es_from_ancova_t_pval}
\title{Convert a two-tailed p-value of an ANCOVA t-test into several effect size measures.}
\usage{
es_from_ancova_t_pval(
  ancova_t_pval,
  cov_outcome_r,
  n_cov_ancova,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_ancova_t_pval
)
}
\arguments{
\item{ancova_t_pval}{a two-tailed p-value of a t-test in an ANCOVA (binary predictor)}

\item{cov_outcome_r}{correlation between the outcome and covariate(s) (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the adjusted \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_t_pval}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 18. Adjusted: ANCOVA statistics, eta-squared'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert a two-tailed p-value of an ANCOVA t-test into several effect size measures.
}
\details{
This function converts the p-value of an ANCOVA (binary predictor) into a t value,
and then relies on the calculations of the \code{\link{es_from_ancova_t}()} function.

\strong{To convert the p-value into a t-value,} the following formula is used (table 12.3 in Cooper):
\deqn{df = n\_exp + n\_nexp + n\_exp - 2 - n\_cov\_ancova}
\deqn{t = | pt(ancova\_f\_pval/2, df = df) |}
Then, calculations of the \code{\link{es_from_ancova_t}()} are applied.
}
\examples{
es_from_ancova_t_pval(
  ancova_t_pval = 0.05, cov_outcome_r = 0.2,
  n_cov_ancova = 3, n_exp = 20, n_nexp = 20
)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
