% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siteFinder.R
\name{siteFinder}
\alias{siteFinder}
\title{Filter environmental monitoring stations (wrapper)}
\usage{
siteFinder(country, siteID, lat, lon, radius, network, vars, id, startDate,
  endDate, includeUnk, elevThresh, ...)
}
\arguments{
\item{country}{(character) Country(ies)/territory(ies) to filter environmental stations. See '?getCountry' for more information.}

\item{siteID}{(character) in the form of: *idType:id*. Environmental monitoring network to use as your Point of Interest (POI). See '?getNearby' for more help.}

\item{lat}{(numeric) Latitude of (POI). See '?getNearby' for more help.}

\item{lon}{(numeric) Longitude of (POI). See '?getNearby' for more help.}

\item{radius}{(numeric) Search radius outward from POI for finding environmental monitoring stations. Defined in kilometers (km). See '?getNearby' for more help}

\item{network}{(character) Network(s)/platform(s) to filter environmental monitoring stations.   Metadata are available for stations in the networks below.  See '?getNetwork' for more information.\cr}

\item{vars}{(character) Elements(s)/variables(s) of interest.  The user can search for general, environmental terms, such as 'temperature,' or 'wind,' and the function will return environmental stations that collect the specified elements ('fuzzy search').  Keep in mind that the database contains ~107,000 stations, worldwide.  Searching for a general term such as 'temperature' will return many stations. The user is advised to search for more granular terms, e.g., using sub terms such as 'air temperature,' or 'soil temperature,' if they wish to narrow their results. See '?getVars' for more help.\cr}

\item{id}{(character) identifier(s) of interest.  Metadata are available for stations with any of the identifiers listed below. It should be noted that a single station man have multiple, associated identifers.  See '?getId' for more information.\cr}

\item{startDate}{(character) "YYYY-MM-DD" used to filter start dates of environmental stations within the metScanR database. Optional if \code{endDate} is initialized. Required if \code{endDate} is missing. See '?getDates' for more information.}

\item{endDate}{(character) "YYYY-MM-DD" used to filter end dates of environmental stations within the metScanR  database. Optional if \code{startDate} is initialized. Required if \code{startDate} is missing. See '?getDates' for more information.}

\item{includeUnk}{(logical) Defaults to FALSE and excludes sites with unknown start dates.  Setting to TRUE will include sites with unknown start dates.  Sites with unknown start dates account for ~71 percent of the metScanR database.  This is a result of undocumented, government (or network/governing body) metadata. Nearly all stations within the database have a known end date, however.  Initializing endDate (while leaving startDate uninitialized) and setting includeUnk=TRUE will more than likely return results than if startDate is also initialized. See '?getDates' for more information.}

\item{elevThresh}{(numeric) defines elevation range to filter metadata.  Units are in meters (m).  If \code{elevThresh} is a single value, the function will return sites within the database that have elevations less than or equal to \code{elevThresh}. Alternatively, if \code{elevThresh} is a numeric vector of length = 2, the function will assign the first component as a midpoint elevation, and the second component as a threshold (range), e.g., \code{elevThresh}=c(100,50) will return sites that have elevations within 100 +/- 50 (m) Above Sea Level. See '?getElevation' for more information.}

\item{...}{Depracated terms from previous version of function.}
}
\value{
A list comprising metadata of environmental monitoring stations from country(ies)/territory(ies) specified in \code{country}\cr
}
\description{
A wrapper function comprising all filtering functions within the metScanR package.  The metScanR database contains metadata from roughly 107,000 stations among ~200 countries/territories and ~18 networks/platforms, worldwide.   This function returns metadata for a subset of those stations, based on the criteria specified by a user.
}
\examples{
\dontrun{
#Return metadata of sites within 50 km of NEON's HARV active from 1965-10-20 to 1986-09-02
  siteFinder(siteID="NEON:HARV",startDate="1965-10-20",
  endDate="1986-09-02",radius=50)

#Return metadata of SCAN, SNTL, and ASOS sites active from at least 2000-01-05 onward
  siteFinder(network=c("SCAN","SNTL","ASOS"),startDate="2000-01-05")

#Return metadata of sites in Brazil with elevations of 1500 +/- 250 (m) Above Sea Level
  siteFinder(elevThresh=c(1500,250),country="Brazil")}
}
\seealso{
\link[metScanR]{getNearby}
\link[metScanR]{getElevation}
\link[metScanR]{getDates}
\link[metScanR]{getNetwork}
\link[metScanR]{getVars}
\link[metScanR]{getCountry}
\link[metScanR]{getId}
\link[metScanR]{mapSiteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
Cody Flagg \cr
Lee Stanish \cr
Sam Weintraub \cr
Derek Smith
}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{climate,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{in-situ,}
\keyword{meteorological}
\keyword{meteorology,}
\keyword{weather,}
