% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-scales.R
\name{scale_label_colour_continuous}
\alias{scale_label_colour_continuous}
\alias{scale_label_alpha_continuous}
\alias{scale_label_size_continuous}
\title{Scales for contour label aesthetics}
\usage{
scale_label_colour_continuous(
  ...,
  aesthetics = c("label_colour"),
  guide = ggplot2::guide_colorbar(available_aes = "label_colour")
)

scale_label_alpha_continuous(
  ...,
  range = c(0.1, 1),
  aesthetics = c("label_alpha")
)

scale_label_size_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  range = c(1, 6),
  transform = "identity",
  guide = "legend"
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:continuous_scale]{continuous_scale}}
  \describe{
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}
    \item{\code{na.value}}{Missing values will be replaced with this value.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful,
for example, to apply colour settings to the colour and fill aesthetics at
the same time, via aesthetics = c("colour", "fill").}

\item{guide}{Type of legend. Use "colourbar" for continuous colour bar,
or "legend" for discrete colour legend.}

\item{range}{Output range of alpha values. Must lie between 0 and 1.}

\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{transform}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{transform_<name>}. If
transformations require arguments, you can call them from the scales
package, e.g. \code{\link[scales:transform_boxcox]{scales::transform_boxcox(p = 2)}}.
You can create your own transformation with \code{\link[scales:new_transform]{scales::new_transform()}}.}
}
\description{
Scales for contour label aesthetics
}
