% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaskLand.R
\name{MaskLand}
\alias{MaskLand}
\title{Mask}
\usage{
MaskLand(lon, lat, mask = "world", wrap = c(0, 360))
}
\arguments{
\item{lon}{a vector of longitudes in degrees in 0-360 format}

\item{lat}{a vector of latitudes in degrees}

\item{mask}{the name of the dataset (that will be load with
\code{\link[maps]{map}}) for creating the mask}

\item{wrap}{the longitude range to be used for a global mask}
}
\value{
A logical vector of the same length as lat and lon where \code{TRUE} means
that the point is inside one of the polygons making up the map. For a global
map (the default), this means that the point is over land.
}
\description{
Creates a  mask
}
\examples{

# Make a sea-land mask
mask <- temperature[lev == 1000, .(lon = lon, lat = lat, land = MaskLand(lon, lat))]
temperature <- temperature[mask, on = c("lon", "lat")]
library(ggplot2)

ggplot(mask, aes(lon, lat)) +
   geom_raster(aes(fill = land))

# Take the temperature difference between land and ocean
diftemp <- temperature[,
          .(tempdif = mean(air[land == TRUE]) - mean(air[land == FALSE])),
           by = .(lat, lev)]

ggplot(diftemp, aes(lat, lev)) +
    geom_contour(aes(z = tempdif, color = after_stat(level))) +
    scale_y_level() +
    scale_x_latitude() +
    scale_color_divergent()


}
