% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MedScan.R
\name{medScan}
\alias{medScan}
\title{Large Scale Single Mediator Hypothesis Testing}
\usage{
medScan(z.alpha, z.beta, method)
}
\arguments{
\item{z.alpha}{the z-test statistic for alpha (exposure effect on the mediator).}

\item{z.beta}{the z-test statistic for beta (mediator effect on the outcome).}

\item{method}{the method to use for testing the mediation effect. It should belong to one of the six methods: \code{"Sobel"}, \code{"MaxP"}, \code{"JT_comp"}, \code{"HDMT"}, \code{"DACT"}, and \code{"Sobel_comp"}.
(1) Sobel’s test (\code{method = "Sobel"}), (2) Max P test
(\code{method = "MaxP"}), (3) joint significance test under the composite null hypothesis (\code{method = "JT_comp"}), (4) high
dimensional mediation testing (\code{method = "HDMT"}), (5) Divide-Aggregate Composite-null Test (\code{method = "DACT"}), and
(6) Sobel’s test under the composite null hypothesis (\code{method = "Sobel_comp"}).}
}
\value{
A list that contains
\itemize{
\item{pvalues: }{p-values for all mediators from the chosen method.}
\item{pi: }{the estimated proportions of the three null cases from the HDMT
method. pi00 is the proportion of alpha=beta=0; pi01 is the proportion of
alpha=0 and beta!=0; and pi10 is the proportion of alpha!=0 and beta=0.}
}
}
\description{
A collection of methods for large scale single mediator hypothesis
testing. The six included methods for testing the mediation effect are Sobel's
test, Max P test, joint significance test under the composite null hypothesis,
high dimensional mediation testing, divide-aggregate composite null test,
and Sobel's test under the composite null hypothesis. Du, J., Zhou, X., Hao, W.,
Liu, Y., Smith, J. A., & Mukherjee, B. (2022). "Methods for Large-scale Single
Mediator Hypothesis Testing: Possible Choices and Comparisons."
}
\details{
The available methods are:
(1) Sobel’s test (\code{method = "Sobel"}), (2) Max P test
(\code{method = "MaxP"}), (3) joint significance test under the composite null hypothesis (\code{method = "JT_comp"}), (4) high
dimensional mediation testing (\code{method = "HDMT"}), (5) Divide-Aggregate Composite-null Test (\code{method = "DACT"}), and
(6) Sobel’s test under the composite null hypothesis (\code{method = "Sobel_comp"}).

We incorporated code from the DACT R package formerly on CRAN. Author: Zhonghua Liu
Maintainer: Zhonghua Liu, zhhliu@hku.hk.
}
\examples{
# simulate data under the mixture null
n=10000
u = runif(n,0,1)
z.alpha = z.beta = rep(NA,0)
pi00 = 0.98
pi10 = 0.01
pi01 = 0.01
for(i in 1:n){
  if(u[i]<=pi00){
    z.alpha[i] = rnorm(1, 0, 1)
    z.beta[i] = rnorm(1, 0, 1)
  } else if (u[i]<= pi00+pi10){
    z.alpha[i] = rnorm(1, 1, 1)
    z.beta[i] = rnorm(1, 0, 1)
  } else {
    z.alpha[i] = rnorm(1, 0, 1)
    z.beta[i] = rnorm(1, 1, 1)
  }
}

# obtain p-values

# method = "Sobel", "MaxP", "HDMT", "Sobel_comp", "JT_comp", "DACT"
obj = medScan(z.alpha = z.alpha, z.beta = z.beta, method = "Sobel")
qqman::qq(obj$pvalues,  xlim = c(0,4), ylim = c(0,4), main = "Sobel")




}
\references{
Sobel, M. E. (1982). Asymptotic confidence intervals for indirect effects in structural equation models. Sociological methodology, 13, 290-312.
MacKinnon, D. P., Lockwood, C. M., Hoffman, J. M., West, S. G., & Sheets, V. (2002). A comparison of methods to test mediation and other intervening variable effects. Psychological methods, 7(1), 83.
Huang, Y. T. (2019). Genome-wide analyses of sparse mediation effects under composite null hypotheses. The Annals of Applied Statistics, 13(1), 60-84.
Liu, Z., Shen, J., Barfield, R., Schwartz, J., Baccarelli, A. A., & Lin, X. (2022). Large-scale hypothesis testing for causal mediation effects with applications in genome-wide epigenetic studies. Journal of the American Statistical Association, 117(537), 67-81.
Dai, J. Y., Stanford, J. L., & LeBlanc, M. (2022). A multiple-testing procedure for high-dimensional mediation hypotheses. Journal of the American Statistical Association, 117(537), 198-213.
Du, J., Zhou, X., Hao, W., Liu, Y., Smith, J. A., & Mukherjee, B. (2022). Methods for Large-scale Single Mediator Hypothesis Testing: Possible Choices and Comparisons. arXiv preprint arXiv:2203.13293.
}
