% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medExtractR_tapering.R
\name{medExtractR_tapering}
\alias{medExtractR_tapering}
\title{Extract Medication Entities From Clinical Note - Extension of \code{\link{medExtractR}} for Tapering applications}
\usage{
medExtractR_tapering(
  note,
  drug_names,
  unit,
  max_dist = 0,
  drug_list = "rxnorm",
  lastdose = FALSE,
  strength_sep = NULL,
  ...
)
}
\arguments{
\item{note}{Text to search.}

\item{drug_names}{Vector of drug names of interest to locate.}

\item{unit}{Strength unit to look for (e.g., \sQuote{mg}).}

\item{max_dist}{Numeric - edit distance to use when searching for \code{drug_names}.}

\item{drug_list}{Vector of known drugs that may end search window. By default calls
\code{\link{rxnorm_druglist}}. Can be supplemented with expressions in \code{\link{addl_expr}}.}

\item{lastdose}{Logical - whether or not last dose time entity should be extracted. See \sQuote{Details}
section below for more information.}

\item{strength_sep}{Delimiter for contiguous medication strengths (e.g., \sQuote{-} for \dQuote{LTG 200-300}).}

\item{\dots}{Parameter settings used in dictionary-based entities. For each dictionary-based
entity, the user can supply the optional arguments \code{<entity>_fun} and \code{<entity>_dict}
to provide custom extraction functions and dictionaries, respectively. If no additional arguments are provided,
\code{medExtractR_tapering} will use \code{\link{extract_generic}} and the default dictionary for each entity.
See \code{\link{extract_entities_tapering}} documentation for details.}
}
\value{
data.frame with entity information. If no dosing
information for the drug of interest is found, the following output will be returned: \cr
\tabular{rrr}{
entity    \tab  expr   \tab    pos\cr
NA \tab  NA \tab  NA
}
The \dQuote{entity} column of the output contains the formatted label for that entity, according to
the following mapping.\cr
drug name: \dQuote{DrugName}\cr
strength: \dQuote{Strength}\cr
dose amount: \dQuote{DoseAmt}\cr
dose strength: \dQuote{DoseStrength}\cr
frequency: \dQuote{Frequency}\cr
intake time: \dQuote{IntakeTime}\cr
duration: \dQuote{Duration}\cr
route: \dQuote{Route}\cr
dose change: \dQuote{DoseChange}\cr
dose schedule: \dQuote{DoseScheule}\cr
time keyword: \dQuote{TimeKeyword}\cr
transition: \dQuote{Transition}\cr
preposition: \dQuote{Preposition}\cr
dispense amount: \dQuote{DispenseAmt}\cr
refill: \dQuote{Refill}\cr
time of last dose: \dQuote{LastDose}\cr
Sample output:\cr
\tabular{rrr}{
entity    \tab  expr   \tab    pos\cr
DoseChange\tab  decrease \tab  66:74\cr
DrugName   \tab Prograf \tab   78:85\cr
Strength  \tab  2 mg   \tab    86:90\cr
DoseAmt   \tab  1     \tab     91:92\cr
Frequency \tab  bid    \tab    101:104\cr
LastDose  \tab  2100    \tab   121:125
}
}
\description{
This function identifies medication entities of interest and returns found
expressions with start and stop positions.
}
\details{
This function uses a combination of regular expressions, rule-based
approaches, and dictionaries to identify various drug entities of interest, with a
particular focus on drugs administered with a tapering schedule.
Specific medications to be found are specified with \code{drug_names}, which
is not case-sensitive or space-sensitive (e.g., \sQuote{lamotrigine XR} is treated
the same as \sQuote{lamotrigineXR}). Entities to be extracted include drug name, strength,
dose amount, dose strength, frequency, intake time, route, duration, dose schedule,
time keyword, preposition, transition, dispense amount, refill, and time of last dose.
While it is still an optional entity in \code{medExtractR_tapering}, if \code{lastdose=TRUE}
then \code{medExtractR_tapering} will search for time of last dose in the same search window used for all
other entities. As a result, there is no need for the \code{lastdose_window_ext} argument. See
\code{\link{extract_entities_tapering}} and \code{\link{extract_lastdose}} for more details.

When searching for medication names of interest, fuzzy matching may be used.
The \code{max_dist} argument determines the maximum edit distance allowed for
such matches. If using fuzzy matching, any drug name with less than 7 characters
will force an exact match, regardless of the value of \code{max_dist}. The default value of 7 was
selected based on a set of training notes for the drug prednisone, and differs slightly from the default
values of 5 for \code{\link{medExtractR}}. The tapering extension does not use the \code{window_length} argument
to define the search window, since tapering schedules can be much longer than a static regimens.
Instead, \code{medExtractR_tapering} dynamically generates the search window based on competing drug names or
phrases, and the distance between consecutive entities. The \code{stength_sep} argument is \code{NULL} by
default, and operates in the same manner as it does in \code{medExtractR}.

By default, the \code{drug_list} argument is \dQuote{rxnorm} which calls \code{data(rxnorm_druglist)}.
A custom drug list in the form of a character string can be supplied instead, or can be appended
to \code{rxnorm_druglist} by specifying \code{drug_list = c("rxnorm", custom_drug_list)}. This uses
publicly available data courtesy of the U.S. National Library of Medicine (NLM), National
Institutes of Health, Department of Health and Human Services; NLM is not responsible for the product and
does not endorse or recommend this or any other product. See \code{rxnorm_druglist} documentation for details.
}
\references{
Nelson SJ, Zeng K, Kilbourne J, Powell T, Moore R. Normalized names for clinical drugs: RxNorm at 6 years.
J Am Med Inform Assoc. 2011 Jul-Aug;18(4)441-8. doi: 10.1136/amiajnl-2011-000116. Epub 2011 Apr 21.
PubMed PMID: 21515544; PubMed Central PMCID: PMC3128404.
}
