/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.eps.EpsUtils;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.PlotType;

public class Axis {
    private Color color;
    private DendrogramOrientation dendroOrientation;
    private int numTicks;
    private int ticksGroup;
    private double x00;
    private double x05;
    private double x10;
    private double x15;
    private double x20;
    private double yMin;
    private double yMax;
    private double yIncr;

    public Axis(SettingsInfo settingsInfo, Scaling scaling) {
        this.color = settingsInfo.getAxisColor();
        this.dendroOrientation = settingsInfo.getDendrogramAdaptedOrientation();
        double d = settingsInfo.getAxisMinValue();
        double d2 = settingsInfo.getAxisMaxValue();
        double d3 = settingsInfo.getAxisIncrement();
        this.numTicks = settingsInfo.getAxisNumberOfTicks();
        this.ticksGroup = settingsInfo.getAxisTicks();
        if (this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH) || this.dendroOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            this.x00 = scaling.transformX(0.0);
            this.x05 = scaling.transformX(0.5);
            this.x10 = scaling.transformX(1.0);
            this.x15 = scaling.transformX(1.5);
            this.x20 = scaling.transformX(2.0);
            this.yMin = scaling.transformY(d);
            this.yMax = scaling.transformY(d2);
            this.yIncr = scaling.transformY(d + d3) - scaling.transformY(d);
        } else {
            this.x00 = scaling.transformY(0.0);
            this.x05 = scaling.transformY(0.5);
            this.x10 = scaling.transformY(1.0);
            this.x15 = scaling.transformY(1.5);
            this.x20 = scaling.transformY(2.0);
            this.yMin = scaling.transformX(d);
            this.yMax = scaling.transformX(d2);
            this.yIncr = scaling.transformX(d + d3) - scaling.transformX(d);
        }
    }

    public void draw(PlotType plotType, Graphics2D graphics2D) {
        Color color = null;
        if (plotType.equals((Object)PlotType.PANEL)) {
            color = graphics2D.getColor();
            graphics2D.setColor(this.color);
        } else {
            EpsUtils.writeLine("gsave");
            EpsUtils.writeLine(EpsUtils.setRGBColor((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f));
        }
        if (this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH) || this.dendroOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            this.drawLine(plotType, graphics2D, this.x10, this.yMin, this.x10, this.yMax);
        } else {
            this.drawLine(plotType, graphics2D, this.yMin, this.x10, this.yMax, this.x10);
        }
        double d = this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH) || this.dendroOrientation.equals((Object)DendrogramOrientation.EAST) ? this.yMin : this.yMax;
        for (int i = 0; i < this.numTicks; ++i) {
            if (this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH) || this.dendroOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
                if (i % this.ticksGroup == 0) {
                    this.drawLine(plotType, graphics2D, this.x00, d, this.x20, d);
                } else {
                    this.drawLine(plotType, graphics2D, this.x05, d, this.x15, d);
                }
            } else if (i % this.ticksGroup == 0) {
                this.drawLine(plotType, graphics2D, d, this.x00, d, this.x20);
            } else {
                this.drawLine(plotType, graphics2D, d, this.x05, d, this.x15);
            }
            if (this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH) || this.dendroOrientation.equals((Object)DendrogramOrientation.EAST)) {
                d += this.yIncr;
                continue;
            }
            d -= this.yIncr;
        }
        if (plotType.equals((Object)PlotType.PANEL)) {
            graphics2D.setColor(color);
        } else {
            EpsUtils.writeLine("grestore");
        }
    }

    private void drawLine(PlotType plotType, Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        if (plotType.equals((Object)PlotType.PANEL)) {
            graphics2D.draw(new Line2D.Double(d, d2, d3, d4));
        } else {
            EpsUtils.writeLine(EpsUtils.dLine((float)((double)EpsUtils.xmin + d), (float)((double)EpsUtils.ymax + d2), (float)((double)EpsUtils.xmin + d3), (float)((double)EpsUtils.ymax + d4)));
        }
    }
}

