% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{plotXYResiduals.pls}
\alias{plotXYResiduals.pls}
\title{Residual XY-distance plot}
\usage{
\method{plotXYResiduals}{pls}(
  obj,
  ncomp = obj$ncomp.selected,
  norm = TRUE,
  log = FALSE,
  main = sprintf("XY-distances (ncomp = \%d)", ncomp),
  cgroup = NULL,
  xlim = NULL,
  ylim = NULL,
  show.limits = c(TRUE, TRUE),
  lim.col = c("darkgray", "darkgray"),
  lim.lwd = c(1, 1),
  lim.lty = c(2, 3),
  show.legend = TRUE,
  legend.position = "topright",
  res = obj$res,
  ...
)
}
\arguments{
\item{obj}{a PLS model (object of class \code{pls})}

\item{ncomp}{how many components to use (by default optimal value selected for the model will be used)}

\item{norm}{logical, normalize distance values or not (see details)}

\item{log}{logical, apply log tranformation to the distances or not (see details)}

\item{main}{title for the plot}

\item{cgroup}{color grouping of plot points (works only if one result object is available)}

\item{xlim}{limits for x-axis}

\item{ylim}{limits for y-axis}

\item{show.limits}{vector with two logical values defining if limits for extreme and/or outliers must be shown}

\item{lim.col}{vector with two values - line color for extreme and outlier limits}

\item{lim.lwd}{vector with two values - line width for extreme and outlier limits}

\item{lim.lty}{vector with two values - line type for extreme and outlier limits}

\item{show.legend}{logical, show or not a legend on the plot (needed if several result objects are available)}

\item{legend.position}{position of legend (if shown)}

\item{res}{list with result objects to show the plot for (by defaul, model results are used)}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows a plot with full X-distance (f) vs. orthogonal Y-distance (z) for PLS model results.
}
\details{
The function presents a way to identify extreme objects and outliers based on both full distance
for X-decomposition (known as f) and squared residual distance for Y-decomposition (z). The
approach has been proposed in [1].

The plot is available only if data driven methods (classic or robust) have been used for
computing of critical limits.
}
\references{
1. Rodionova O. Ye., Pomerantsev A. L. Detection of Outliers in Projection-Based Modeling.
Analytical Chemistry (2020, in publish). doi: 10.1021/acs.analchem.9b04611
}
