% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcrals.R
\name{mcrals.fcnnls}
\alias{mcrals.fcnnls}
\title{Fast combinatorial non-negative least squares}
\usage{
mcrals.fcnnls(
  D,
  A,
  tol = 10 * .Machine$double.eps * as.numeric(sqrt(crossprod(A[, 1]))) * nrow(A)
)
}
\arguments{
\item{D}{a matrix}

\item{A}{a matrix}

\item{tol}{tolerance parameter for algorithm convergence}
}
\description{
Fast combinatorial non-negative least squares
}
\details{
Computes Fast combinatorial NNLS solution for B: D = AB' subject to B >= 0. Implements
the method described in [1].
}
\references{
1. Van Benthem, M.H. and Keenan, M.R. (2004), Fast algorithm for the solution of large scale
non-negativity-constrained least squares problems. J. Chemometrics, 18: 441-450.
doi:10.1002/cem.889
}
