% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_modelinputs.R
\name{get_subnational_modelinputs}
\alias{get_subnational_modelinputs}
\alias{get_modelinputs}
\title{Get JAGS model inputs}
\usage{
get_modelinputs(startyear = 1990, endyear = 2030.5, nsegments = 12, raw_data)
}
\arguments{
\item{startyear}{The year you wish to begin your predictions from. Default is 1990.}

\item{endyear}{The year you wish to finish your predictions. Default is 2030.5.}

\item{nsegments}{The number of knots you wish to use in your basis functions. Default is 12.}

\item{raw_data}{The list of arguments and family planning source data from the 'get_data' function.}
}
\value{
A list of modelling inputs for the JAGS model.
\enumerate{
\item Tstar is the year index for the most recent survey in each province.
\item Kstar is the knot index that aligns with Tstar.
\item B.ik are the basis functions.
\item n_years are total number of years
\item n_obs  are the total number of observations
\item K are the number of knots.
\item H is K-1. Used in the calculation of first order differences of spline coefficients.
\item P_count is the number of subnational provinces/regions.
\item M_count is the number of modern contraceptive methods.
\item matchsubnat is the subnational province indexing to match the observed data to the predictions.
\item matchcountry is the country indexing to match the observed data to the predictions.
\item matchmethod is the method indexing to match the observed data to the predictions.
\item matchyears is the year indexing to match the observed data to the predictions.
}
}
\description{
Get JAGS model inputs
}
\examples{
\donttest{
raw_data <- get_data(national=FALSE, local=TRUE, mycountry="Nepal")
jagsdata <- get_modelinputs(startyear=1990, endyear=2030.5, nsegments=12, raw_data)
}
}
