% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_vfac.R
\name{vfac}
\alias{vfac}
\title{Create a model component object for a variance factor component in the variance function of a
gaussian sampling distribution}
\usage{
vfac(
  factor = "local_",
  prior = pr_invchisq(df = 1, scale = 1),
  name = "",
  debug = FALSE,
  e = parent.frame()
)
}
\arguments{
\item{factor}{The name of a factor variable. The name \code{"local_"} has a special meaning,
and assigns a different variance scale parameter to each data unit.
In case of inverse chi-squared priors this implies that the marginal sampling distribution
is a t distribution. In case of exponential priors the marginal sampling distribution
is a Laplace or double exponential distribution.}

\item{prior}{the prior assigned to the variance factors. Currently the prior can be inverse chi-squared
or exponential, specified by a call to \code{\link{pr_invchisq}} or \code{\link{pr_exp}}, respectively.
The default priors are inverse chi-squared with 1 degree of freedom. See the help pages of the
prior specification functions for details on how to set non-default priors.}

\item{name}{The name of the variance model component. This name is used in the output of the MCMC simulation
function \code{\link{MCMCsim}}. By default the name will be 'vfac' with the number of the variance model
term attached.}

\item{debug}{If \code{TRUE} a breakpoint is set at the beginning of the posterior
draw function associated with this model component. Mainly intended for developers.}

\item{e}{For internal use only.}
}
\value{
An object with precomputed quantities and functions for sampling from
 prior or conditional posterior distributions for this model component. Only intended
 for internal use by other package functions.
}
\description{
This function is intended to be used on the right hand side of the \code{formula.V} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}.
}
