% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{correlation}
\alias{correlation}
\title{Correlation structures}
\description{
Element 'factor' of a model component is a formula composed of several possible terms described below.
It is used to derive a (sparse) precision matrix for a set of coefficient, and possibly a matrix representing
a set of linear constraints to be imposed on the coefficient vector.
\describe{
  \item{iid(f)}{Independent effects corresponding to the levels of factor \code{f}.}
  \item{RW1(f, circular=FALSE)}{First-order random walk.}
  \item{RW2(f)}{Second-order random walk.}
  \item{AR1(f, phi)}{First-order autoregressive correlation structure among the levels of \code{f}.
    Required argument \code{phi} (fixed number for now).}
  \item{season(f, period)}{Dummy seasonal with period \code{period}.}
  \item{spatial(f, poly.df, snap, queen, derive.constraints=FALSE)}{CAR spatial correlation.
    Argument \code{poly.df} should be an object of class \code{SpatialPolygonsDataFrame} obtained
    e.g. from reading in a shape file with \code{\link[maptools]{readShapeSpatial}} from
    package \pkg{maptools}. Arguments \code{snap} and \code{queen} are passed to \code{\link[spdep]{poly2nb}}.
    If \code{derive.constraints=TRUE} the constraint matrix for an IGMRF model component
    is formed by computing the singular vectors of the precision matrix.}
  \item{custom(f, QD)}{A custom precision or incidence matrix associated with factor f can be passed to argument \code{QD}.}
}
}
