% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModalEM.R
\name{GaussianMixtureMEM}
\alias{GaussianMixtureMEM}
\title{Modal EM algorithm for Gaussian Mixtures}
\usage{
GaussianMixtureMEM(
  data,
  pro,
  mu,
  sigma,
  control = list(eps = 1e-05, maxiter = 1000, stepsize = function(t) 1 - exp(-0.1 * t),
    denoise = TRUE, alpha = 0.01, keep.path = FALSE),
  ...
)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame of observations.
Categorical variables are not allowed. If a matrix or data frame, rows
correspond to observations (\eqn{n}) and columns correspond to variables
(\eqn{d}).}

\item{pro}{A \eqn{(G \times 1)}{(G x 1)} vector of mixing probabilities for
a Gaussian mixture of \eqn{G} components.}

\item{mu}{A \eqn{(d \times G)}{(d x G)} matrix of component means for a
\eqn{d}-variate Gaussian mixture of \eqn{G} components.}

\item{sigma}{A \eqn{(d \times d \times G)}{(d x d x G)} array of component
covariance matrices for a \eqn{d}-variate Gaussian mixture of \eqn{G}
components.}

\item{control}{A list of control parameters:
\itemize{
\item \verb{eps, maxiter} Numerical values setting the tolerance and the maximum
number of iterations of the MEM algorithm;
\item \code{stepsize} A function controlling the step size of the MEM algorithm;
\item \code{denoise} A logical, if \code{TRUE} a denoising procedure is used when
\eqn{d > 1} to discard all modes whose density is negligible;
\item \code{alpha} A numerical value used when \code{denoise = TRUE} for computing the
hypervolume of central \eqn{(1-\alpha)100}{(1-alpha)100} region of a
multivariate Gaussian;
\item \code{keep.path} A logical controlling whether or not the full paths
to modes must be returned.
}}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns a list containing the following elements:
\itemize{
\item \code{n} The number of input data points.
\item \code{d} The number of variables/features.
\item \code{parameters} The Gaussian mixture parameters.
\item \code{iter} The number of iterations of MEM algorithm.
\item \code{nmodes} The number of modes estimated by the MEM algorithm.
\item \code{modes} The coordinates of modes estimated by MEM algorithm.
\item \code{path} If requested, the coordinates of full paths to modes for each data point.
\item \code{logdens} The log-density at the estimated modes.
\item \code{logvol} The log-volume used for denoising (if requested).
\item \code{classification} The modal clustering classification of input data points.
}
}
\description{
A function implementing a fast and efficient Modal EM algorithm for Gaussian
mixtures.
}
\references{
Scrucca L. (2021) A fast and efficient Modal EM algorithm for
Gaussian mixtures. \emph{Statistical Analysis and Data Mining}, 14:4,
305–314. \doi{doi: 10.1002/sam.11527}
}
\seealso{
\code{\link[=MclustMEM]{MclustMEM()}}.
}
\author{
Luca Scrucca
}
