% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rows_if_not_exists.R
\name{add_rows_if_not_exists}
\alias{add_rows_if_not_exists}
\title{Add Missing Rows to a Data Frame}
\usage{
add_rows_if_not_exists(
  module_abundance,
  add_rows = c("K14126", "K14128", "K14127")
)
}
\arguments{
\item{module_abundance}{A data frame with row names representing KO identifiers
(e.g., K numbers) and numeric abundance values}

\item{add_rows}{A character vector of row names (KO identifiers) that should be
present in the output. Defaults to c("K14126","K14128","K14127")}
}
\value{
The original data frame with additional rows (if any were missing) where
all values are set to 0. Row and column names are preserved.
}
\description{
This function checks if specified rows exist in a data frame, and if not,
adds them with all values set to 0. Useful for ensuring consistent KO
representation across samples.
}
