% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_main_function.R
\name{mcglm}
\alias{mcglm}
\title{Fitting Multivariate Covariance Generalized Linear Models}
\source{
Bonat, W. H. and Jorgensen, B. (2016) Multivariate
    covariance generalized linear models.
    Journal of Royal Statistical Society - Series C 65:649--675.

Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mcglm(linear_pred, matrix_pred, link, variance, covariance,
       offset, Ntrial, power_fixed, data, control_initial,
       contrasts, weights, control_algorithm)
}
\arguments{
\item{linear_pred}{a list of formula see \code{\link[stats]{formula}}
for details.}

\item{matrix_pred}{a list of known matrices to be used on the matrix
linear predictor. For details see
\code{\link[mcglm]{mc_matrix_linear_predictor}}.}

\item{link}{a list of link functions names. Options are:
\code{"logit"}, \code{"probit"}, \code{"cauchit"}, \code{"cloglog"},
\code{"loglog"}, \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"1/mu^2"} and \code{"inverse"}.
See \code{\link{mc_link_function}} for details.}

\item{variance}{a list of variance functions names.
Options are: \code{"constant"}, \code{"tweedie"},
\code{"poisson_tweedie"}, \code{"binomialP"} and \code{"binomialPQ"}. \cr
See \code{\link{mc_variance_function}} for details.}

\item{covariance}{a list of covariance link functions names.
Options are: \code{"identity"}, \code{"inverse"} and
exponential-matrix \code{"expm"}.}

\item{offset}{a list of offset values if any.}

\item{Ntrial}{a list of number of trials on Bernoulli
experiments. It is useful only for \code{binomialP} and
\code{binomialPQ} variance functions.}

\item{power_fixed}{a list of logicals indicating if the values of the
power parameter should be estimated or not.}

\item{data}{a data frame.}

\item{control_initial}{a list of initial values for the fitting
algorithm. If no values are supplied automatic initial values
will be provided by the function \code{\link{mc_initial_values}}.}

\item{contrasts}{extra arguments to passed to
\code{\link[stats]{model.matrix}}.}

\item{weights}{A list of weights for model fitting. Each element of
the list should be a vector of weights of size equals the number of
observations. Missing observations should be annotated as NA.}

\item{control_algorithm}{a list of arguments to be passed for the
fitting algorithm. See \code{\link[mcglm]{fit_mcglm}} for
details.}
}
\value{
mcglm returns an object of class 'mcglm'.
}
\description{
The function \code{mcglm} is used to fit multivariate
    covariance generalized linear models.
    The models are specified by a set of lists giving a symbolic
    description of the linear and matrix linear predictors.
    The user can choose between a list of link, variance and covariance
    functions. The models are fitted using an estimating function
    approach, combining quasi-score functions for regression
    parameters and Pearson estimating function for covariance
    parameters. For details see Bonat and Jorgensen (2016).
}
\seealso{
\code{fit_mcglm}, \code{mc_link_function} and
\code{mc_variance_function}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
