% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_derivative_expm.R
\name{mc_derivative_expm}
\alias{mc_derivative_expm}
\title{Derivative of exponential-matrix function}
\usage{
mc_derivative_expm(dU, UU, inv_UU, Q, n = dim(UU)[1], sparse = FALSE)
}
\arguments{
\item{dU}{A matrix.}

\item{UU}{A matrix.}

\item{inv_UU}{A matrix.}

\item{Q}{A numeric vector.}

\item{n}{A numeric.}

\item{sparse}{Logical.}
}
\value{
A matrix.
}
\description{
Compute the derivative of the exponential-matrix
    covariance link function.
}
\details{
Many arguments required by this function are provide by the
    \code{link[mcglm]{mc_dexpm}}.  The argument dU is the derivative
    of the U matrix with respect to the models parameters. It should
    be computed by the user.
}
\seealso{
\code{\link[Matrix]{expm}}, \code{link[mcglm]{mc_dexp_gold}}
    and \code{link[mcglm]{mc_dexpm}}.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
