% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_gosho.R
\name{GOSHO}
\alias{GOSHO}
\title{Gosho Information Criterion}
\source{
Wang, M. (2014). Generalized Estimating Equations in Longitudinal Data
Analysis: A Review and Recent Developments. Advances in Statistics, 1(1)1--13.
}
\usage{
GOSHO(object, id, verbose = TRUE)
}
\arguments{
\item{object}{an object of \code{mcglm} class.}

\item{id}{a vector which identifies the clusters or groups.
The length and order of id should be the same as the number of
observations. Data are assumed to be sorted so that observations
on a cluster are contiguous rows for all entities in the formula.}

\item{verbose}{logical. Print or not the GOSHO value.}
}
\value{
The value of the GOSHO criterion.
Note that the function assumes that the data are in the correct order.
}
\description{
Extract the Gosho Information Criterion (GOSHO)
for an object of \code{mcglm} class.
WARNING: This function is limited to models with ONE response variable.
This function is general useful only for longitudinal data analysis.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
\seealso{
\code{gof}, \code{plogLik}, \code{pAIC}, \code{pKLIC},
\code{ESS} and \code{RJC}.
}

