% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sds.R
\name{sd_rs}
\alias{sd_rs}
\title{Calculate standard deviation for each location under each regime.}
\usage{
sd_rs(x, label)
}
\arguments{
\item{x}{A \code{data.frame} or \code{matrix}.}

\item{label}{A vector of regime labels. Its length must be the same as
the number rows in \code{x}.}
}
\value{
A list of standard deviations for each regime.
}
\description{
Calculate standard deviation for each location under each regime.
}
\examples{
set.seed(123)
x <- matrix(rnorm(200), nrow = 100)
label <- sample(1:2, 100, replace = TRUE)
sd_rs(x, label = factor(label))
}
