% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TwoPointCrossOverOnDoublesUsingBytes}
\alias{TwoPointCrossOverOnDoublesUsingBytes}
\title{Two-point Crossover operation on the two vectors of doubles using their byte representations}
\usage{
TwoPointCrossOverOnDoublesUsingBytes(d1, d2, cutpoint1, cutpoint2)
}
\arguments{
\item{d1}{A vector of doubles of the first parent}

\item{d2}{A vector of doubles of the second parent}

\item{cutpoint1}{An integer between 1 and chromosome length for crossover cutting}

\item{cutpoint2}{An integer between cutpoint1 and chromosome length for crossover cutting}
}
\value{
List of two double vectors of offspring
}
\description{
This function is a C++ wrapper for crossing-over of two double vectors of candidate solutions using their byte representations
}
\examples{
d1 <- runif(3)
d2 <- runif(3)
cutpoints <- sort(sample(1:(length(d1)*SizeOfDouble()), 2, replace = FALSE))
offspring <- TwoPointCrossOverOnDoublesUsingBytes(d1,d2,cutpoints[1], cutpoints[2])
print("Parents:")
print(d1)
print(d2)
print("Offspring:")
print(offspring[[1]])
print(offspring[[2]])
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\seealso{
TwoPointCrossOver

OnePointCrossOver

UniformCrossOver

OnePointCrossOverOnDoublesUsingBytes
}

