% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oplibrary.R
\name{mcga2}
\alias{mcga2}
\title{Performs a machine-coded genetic algorithm search for a given optimization problem}
\usage{
mcga2(fitness, ..., min, max,
  population = gaControl("real-valued")$population,
  selection = gaControl("real-valued")$selection,
  crossover = byte_crossover, mutation = byte_mutation, popSize = 50,
  pcrossover = 0.8, pmutation = 0.1, elitism = base::max(1, round(popSize
  * 0.05)), maxiter = 100, run = maxiter, maxFitness = Inf,
  names = NULL, parallel = FALSE, monitor = gaMonitor, seed = NULL)
}
\arguments{
\item{fitness}{The goal function to be maximized}

\item{...}{Additional arguments to be passed to the fitness function}

\item{min}{Vector of lower bounds of variables}

\item{max}{Vector of upper bounds of variables}

\item{population}{Initial population. It is \code{gaControl("real-valued")$population} by default.}

\item{selection}{Selection operator. It is \code{gaControl("real-valued")$selection} by default.}

\item{crossover}{Crossover operator. It is \code{byte_crossover} by default.}

\item{mutation}{Mutation operator. It is \code{byte_mutation} by default. Other values can be given including \code{byte_mutation_random}, 
\code{byte_mutation_dynamic} and \code{byte_mutation_random_dynamic}}

\item{popSize}{Population size. It is 50 by default}

\item{pcrossover}{Probability of crossover. It is 0.8 by default}

\item{pmutation}{Probability of mutation. It is 0.1 by default}

\item{elitism}{Number of elitist solutions. It is \code{base::max(1, round(popSize*0.05))} by default}

\item{maxiter}{Maximum number of generations. It is 100 by default}

\item{run}{The genetic search is stopped if the best solution has not any improvements in last \code{run} generations. By default it is \code{maxiter}}

\item{maxFitness}{Upper bound of the fitness function. By default it is Inf}

\item{names}{Vector of names of the variables. By default it is \code{NULL}}

\item{parallel}{If TRUE, fitness calculations are performed parallel. It is FALSE by default}

\item{monitor}{The monitoring function for printing some information about the current state of the genetic search. It is \code{gaMonitor} by default}

\item{seed}{The seed for random number generating. It is \code{NULL} by default}
}
\value{
Returns an object of class \code{ga-class}
}
\description{
\code{mcga2} is the improvement version of the standard mcga function as it is based on the \code{GA::ga} function. The 
\code{byte_crossover} and the \code{byte_mutation} operators are the main reproduction operators and these operators uses the byte 
representations of parents in the computer memory.
}
\examples{
f <- function(x){ 
  return(-sum( (x-5)^2 ) )
}
myga <- mcga2(fitness = f, popSize = 100, maxiter = 300, 
              min = rep(-50,5), max = rep(50,5))
print(myga@solution)
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\references{
M.H.Satman (2013), Machine Coded Genetic Algorithms for Real Parameter Optimization Problems, Gazi University Journal of Science, Vol 26, No 1, pp. 85-95

Luca Scrucca (2013). GA: A Package for Genetic Algorithms in R. Journal of Statistical Software, 53(4), 1-37. URL \url{http://www.jstatsoft.org/v53/i04/}
}
\seealso{
GA::ga
}

