% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{mcen_workhorse}
\alias{mcen_workhorse}
\title{Estimates the clusters and provides the coefficients for an mcen object}
\usage{
mcen_workhorse(beta, delta = NULL, xx, xy, family = "mgaussian",
  ky = NULL, gamma_y = 0.5, eps = 1e-05, clusterMethod = "kmeans",
  clusterIterations = 100, clusterStartNum = 30, cluster_y = NULL,
  max_iter = 10, x = x)
}
\arguments{
\item{beta}{The initial value of the coefficients}

\item{delta}{The sparsity (L1) tuning parameter}

\item{xx}{Matrix of transpose of x times x.}

\item{xy}{Matrix of transpose of x times y.}

\item{family}{Type of likelihood used two options "mgaussian" or "mbinomial"}

\item{ky}{Number of clusters for the response}

\item{gamma_y}{Penalty for the y clusters difference in predicted values}

\item{eps}{Convergence criteria}

\item{clusterMethod}{Which clustering method was used, currently support kmeans or kmeanspp}

\item{clusterIterations}{Number of iterations for cluster convergence}

\item{clusterStartNum}{Number of random starting points for clustering}

\item{cluster_y}{An a priori definition of clusters. If clusters are provided they will remain fixed and are not estimated. Objective function is then convex.}

\item{max_iter}{The maximum number of iterations for estimating the coefficients}

\item{x}{The design matrix}
}
\description{
Estimates the clusters and provides the coefficients for an mcen object
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
