\name{sdf_quicksort}
\alias{sdf_quicksort}
\title{
Fast reordering of a list of class "sdfdata"
}
\description{
Reorders a list of class \code{"sdfdata"} based on hierarchical clustering in connection with optimal leaf ordering  for displaying scagnostics results in scaggrams. 
}
\usage{
sdf_quicksort(sdfdata)
}
\arguments{
  \item{sdfdata}{
A list of class \code{"sdfdata"} generated by function \code{sdf} or \code{scag2sdf}. 
}
}
\details{
The reordering is based on clustering of the variables of \code{sdfdata$data}.

\code{1-cor(sdfdata$data)} is used as a similarity measure. The linkage method is \code{average}. Function \code{seriate} from package \pkg{seriation} is used. 
}
\value{
A list of class \code{"sdfdata"}.
}
\references{
Z. Bar-Joseph, E. D. Demaine, D. K. Gifford, and T. Jaakkola (2001) Fast Optimal Leaf Ordering for Hierarchical Clustering \emph{Bioinformatics} \bold{17}(1) 22--29.

M. Hahsler, K. Hornik und C. Buchta (2008) Getting Things in Order: An Introduction
to the R Package seriation  \emph{Journal of Statistical Software} \bold{25}(3)  1--34.

}
\author{
Katrin Grimm
}

\note{
This is a reordering based on similarities of variables not scatterplots. For reordering based on similarities of scatterplots see \code{\link{sdf_sort}}.

}

\seealso{
\code{\link{sdf}}, \code{\link{scag2sdf}}, \code{\link{sdf_sort}}, \code{\link{scaggram}}, \code{\link{iascaggram}},

\code{\link[seriation]{seriate}} in package \pkg{seriation}
}
\examples{
data(Election2005)
# consider only demographic/economic information
election05_ds <- Election2005[,1:40]
\dontrun{
scagdf <- sdf(election05_ds)
# new order 
scagdf_o <- sdf_quicksort(scagdf)
# compare scaggrams
par(mfrow=c(1,2))
scaggram(scagdf,select=(c(1,5,9)))
scaggram(scagdf_o,select=(c(1,5,9)))
}
}
\keyword{two-dimensional meausures and selections}