% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{vec_from_store_byname}
\alias{vec_from_store_byname}
\title{Create a vector with labels from a matrix and values from a vector store}
\usage{
vec_from_store_byname(
  a,
  v,
  a_piece = "all",
  v_piece = "all",
  colname = NULL,
  column = TRUE,
  notation = if (is.list(a)) {     list(RCLabels::bracket_notation) } else {    
    RCLabels::bracket_notation },
  prepositions = if (is.list(a)) {     list(RCLabels::prepositions) } else {    
    RCLabels::prepositions }
)
}
\arguments{
\item{a}{A matrix from which row or column labels are taken.
Can also be a list or the name of a column in a data frame.}

\item{v}{A vector from which values are taken, when \code{a_piece} matches \code{v_piece}.
Can also be a list or the name of a column in a data frame.}

\item{a_piece}{The piece of labels on \code{a} that is to be matched. Default is "all".}

\item{v_piece}{The piece of labels on \code{v} that is to be matched. Default is "all".}

\item{colname}{The name of the output vector's 1-sized dimension
(the only column if \code{column} is \code{TRUE}, the only row otherwise).
Default is \code{NULL}, meaning that the name of the 1-sized dimension in \code{v}
should be used.}

\item{column}{Tells whether a column vector (if \code{TRUE}, the default) or a row vector (if \code{FALSE}) should be created.}

\item{notation}{The notation for the row and column labels.
Default is \code{RCLabels::bracket_notation}, wrapped as a list if \code{a} is a list.}

\item{prepositions}{The strings that will count for prepositions.
Default is \code{RCLables::prepositions}, wrapped as a list if \code{a} is a list..}
}
\value{
A vector with names from \code{a} and values from \code{v}.
}
\description{
When a matrix is multiplied by a vector byname,
naming can be tricky.
There are times when pieces of the vector labels should be matched to
pieces of the matrix labels.
This function helps by performing the matching byname.
For this function, vector \code{v} is considered a store of values
from which the output vector is created
using special matching rules between \code{a} and \code{v}.
}
\details{
The output of this function is a vector
(a column vector if \code{column} is \code{TRUE}, the default;
a row vector if \code{column} is \code{FALSE}).
The label of the size = 1 dimension is taken from \code{colname}
(so named, because the default is to return a column vector).
The labels of the long dimension are taken from matrix \code{a}
(the row names of \code{a} if \code{column} is \code{TRUE};
the column names of \code{a} if \code{column} is \code{FALSE}).
The values of the output vector are obtained from v
when \code{a_piece} matches \code{v_piece} using the \code{RCLabels} package.
The \code{v_piece}s of \code{v} must be unique.
The default values for \code{a_piece} and \code{v_piece} are "all",
meaning that the entire label should be matched.
Other options for \code{a_piece} and \code{v_piece} are "pref" and "suff",
which will match the prefix or suffix of the labels.
Alternatively, prepositions can be given such that
objects of prepositions will be matched.
Examples include "from" or "in".
Row and column types from \code{v} are applied to the output.
If the piece given in \code{a_piece} is not present in row or column names of \code{a},
\code{NA_real_} is returned.
If the piece given in \code{v_piece} is not present in row or column names of \code{v},
\code{NA_real_} is returned.

Note that \code{notation} and \code{prepositions} should be lists if \code{a} is a list
but a single value otherwise.
The default values of \code{notation} and \code{prepositions} take care of this requirement,
switching on the type of \code{a} (list or not).
}
\examples{
a <- matrix(42, nrow = 3, ncol = 5, 
            dimnames = list(c("Electricity [from b in c]", 
                              "Coal [from e in f]", 
                              "Crude oil [from Production in USA]"), 
                            c("Main activity producer electricity plants", 
                              "Wind turbines", 
                              "Oil refineries", 
                              "Coal mines", 
                              "Automobiles"))) \%>\%
  setrowtype("Product") \%>\% setcoltype("Industry")
a
v <- matrix(1:7, nrow = 7, ncol = 1, 
            dimnames = list(c("Electricity", 
                              "Peat", 
                              "Hydro", 
                              "Crude oil",
                              "Coal", 
                              "Hard coal (if no detail)", 
                              "Brown coal"), 
                            "phi")) \%>\%
  setrowtype("Product") \%>\% setcoltype("phi")
v
vec_from_store_byname(a, v, a_piece = "pref")
vec_from_store_byname(a, v, a_piece = "noun")

v2 <- matrix(1:7, nrow = 7, ncol = 1, 
             dimnames = list(c("Electricity", 
                               "Peat", 
                               "USA", 
                               "c",
                               "Coal", 
                               "Hard coal (if no detail)", 
                               "f"), 
                             "phi")) \%>\%
  setrowtype("Product") \%>\% setcoltype("phi")
vec_from_store_byname(a, v2, a_piece = "in")

# Works with lists
v3 <- matrix(1:7, nrow = 7, ncol = 1, 
             dimnames = list(c("Electricity [from USA]", 
                               "Peat [from nowhere]", 
                               "Production [from GHA]", 
                               "e [from ZAF]",
                               "Coal [from AUS]", 
                               "Hard coal (if no detail) [from GBR]", 
                               "b [from Nebraska]"), 
                             "phi")) \%>\%
  setrowtype("Product") \%>\% setcoltype("phi")
a_list <- list(a, a)
v_list <- list(v3, v3)
vec_from_store_byname(a_list, v_list, a_piece = "in", v_piece = "from")

# Also works in a data frame
df <- tibble::tibble(a = list(a, a, a), 
                     v = list(v3, v3, v3))
df \%>\%
  dplyr::mutate(
    actual = vec_from_store_byname(a = a, v = v, a_piece = "in", v_piece = "from")
  )
}
